/* FILE: mqueue.h                               (D. Tottingham  03/24/91)

This is an include file of defines, data structure definitions and
external declarations that are common in the mqueue module.

*/

#ifndef _MQUEUE_
#define _MQUEUE_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"
#include "mlatlon.h"
#include "powrstor.h"
#include "suds.h"


/************************************************************************
                        STRUCTURE DEFINITIONS

The following structure definitions are included here so that all
modules can have access to them.

************************************************************************/
typedef struct {
        unsigned int channel;
        double rel_arrival;
        int signal;
        int noise;
        SUDS_STRUCTTAG structtag;
        SUDS_FEATURE info;
} Q_ARRIVAL;

typedef struct {
        int far * data;
        unsigned int buffer_status;
        unsigned int dynamic_range;
        unsigned int buffer_number;
        unsigned int buffer_size;
        double seconds_in_buffer;
        SUDS_STRUCTTAG structtag;
        SUDS_MUXDATA info;
        struct STORheap far * ST_heap_ptr;  /* temporarily a far pointer */
        FLAG bank_switched;
} Q_BUFFER;

typedef struct {
        unsigned int channel;
        int signal;
        int noise;
        SUDS_STRUCTTAG structtag;
        SUDS_TRIGGERS info;
} Q_CHANNEL;

typedef struct {
        SUDS_STRUCTTAG structtag;
        SUDS_ORIGIN info;
} Q_LOCATION;

typedef struct {
        unsigned int channel;
        SUDS_STRUCTTAG structtag;
        SUDS_FEATURE info;
} Q_MAGNITUDE;

typedef struct {
        double x, y;
        double xsq, ysq;
        LL_LATLON mean_latlon;
        SUDS_STRUCTTAG structtag;
        SUDS_STATIONCOMP info;
        FLAG in_masterlist;
} Q_STATION;

typedef struct {
        double trigger_time;
        Q_CHANNEL far * qch;
        FLAG trigger_flag;
} Q_TRIGGER;

typedef union {
        Q_ARRIVAL far * arrival;
        Q_BUFFER  far * buffer;
        Q_CHANNEL far * channel;
        Q_LOCATION far * location;
        Q_MAGNITUDE far * magnitude;
        Q_STATION far * station;
        Q_TRIGGER * trigger;
} Q_TYPE;

typedef struct q_link {
        Q_TYPE type;
        struct q_link * next;
} Q_LINK;

typedef struct {
        Q_LINK * head;
        Q_LINK * tail;
} Q_QUEUE;


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC FLAG q_delete_link (Q_QUEUE *, Q_LINK *, Q_LINK *, Q_TYPE *);
PUBLIC FLAG q_dequeue (Q_QUEUE *, Q_TYPE *);
PUBLIC void q_enqueue (Q_QUEUE *, Q_TYPE);
PUBLIC void q_initialize (Q_QUEUE *);
PUBLIC void q_insert_link (Q_QUEUE *, Q_LINK *, Q_TYPE);

#endif
